#include "gfx/legato/generated/le_gen_assets.h"

/*****************************************************************************
 * Legato String Table
 * Encoding        ASCII
 * Language Count: 1
 * String Count:   11
 *****************************************************************************/

/*****************************************************************************
 * string table data
 * 
 * this table contains the raw character data for each string
 * 
 * unsigned short - number of indices in the table
 * unsigned short - number of languages in the table
 * 
 * index array (size = number of indices * number of languages
 * 
 * for each index in the array:
 *   unsigned byte - the font ID for the index
 *   unsigned byte[3] - the offset of the string codepoint data in
 *                      the table
 * 
 * string data is found by jumping to the index offset from the start
 * of the table
 * 
 * string data entry:
 *     unsigned short - length of the string in bytes (encoding dependent)
 *     codepoint data - the string data
 ****************************************************************************/

const uint8_t stringTable_data[242] =
{
    0x0B,0x00,0x01,0x00,0x03,0x30,0x00,0x00,0x02,0x44,0x00,0x00,0x03,0x6A,0x00,0x00,
    0x04,0x72,0x00,0x00,0x04,0x8C,0x00,0x00,0x04,0xAA,0x00,0x00,0x04,0xBC,0x00,0x00,
    0x03,0xC8,0x00,0x00,0x04,0xCE,0x00,0x00,0x04,0xDA,0x00,0x00,0x03,0xEC,0x00,0x00,
    0x11,0x00,0x4C,0x45,0x44,0x20,0x54,0x6F,0x75,0x63,0x68,0x20,0x43,0x6F,0x6E,0x74,
    0x72,0x6F,0x6C,0x00,0x24,0x00,0x54,0x6F,0x75,0x63,0x68,0x20,0x41,0x6E,0x79,0x77,
    0x68,0x65,0x72,0x65,0x2C,0x20,0x67,0x65,0x74,0x74,0x69,0x6E,0x67,0x20,0x62,0x61,
    0x63,0x6B,0x20,0x74,0x6F,0x20,0x54,0x4F,0x50,0x2E,0x06,0x00,0x4F,0x4E,0x2F,0x4F,
    0x46,0x46,0x18,0x00,0x50,0x49,0x43,0x33,0x32,0x4D,0x5A,0x20,0x45,0x76,0x61,0x6C,
    0x75,0x61,0x74,0x69,0x6F,0x6E,0x20,0x42,0x6F,0x61,0x72,0x64,0x1C,0x00,0x49,0x4E,
    0x54,0x30,0x37,0x30,0x3A,0x20,0x20,0x37,0x2E,0x30,0x22,0x20,0x20,0x38,0x30,0x30,
    0x78,0x34,0x38,0x30,0x20,0x70,0x69,0x78,0x65,0x6C,0x10,0x00,0x54,0x6F,0x75,0x63,
    0x68,0x20,0x4C,0x43,0x44,0x20,0x49,0x4E,0x54,0x30,0x37,0x30,0x09,0x00,0x62,0x79,
    0x20,0x4C,0x65,0x67,0x61,0x74,0x6F,0x00,0x04,0x00,0x4E,0x45,0x58,0x54,0x0A,0x00,
    0x57,0x65,0x6C,0x63,0x6F,0x6D,0x65,0x20,0x74,0x6F,0x0F,0x00,0x3C,0x48,0x61,0x72,
    0x6D,0x6F,0x6E,0x79,0x20,0x56,0x65,0x72,0x2E,0x33,0x3E,0x00,0x04,0x00,0x42,0x41,
    0x43,0x4B,
};

/* font asset pointer list */
leFont* fontList[5] =
{
    (leFont*)&Bold_32,
    (leFont*)&Bold_28,
    (leFont*)&Std_28,
    (leFont*)&Bold_24,
    (leFont*)&Bold_36,
};

const leStringTable stringTable =
{
    {
        LE_STREAM_LOCATION_ID_INTERNAL, // data location id
        (void*)stringTable_data, // data address pointer
        242, // data size
    },
    (void*)stringTable_data, // string table data
    fontList, // font lookup table
    LE_STRING_ENCODING_ASCII // encoding standard
};


// string list
leTableString string_LED_Touch_Control;
leTableString string_TouchAnywhere;
leTableString string_On_Off;
leTableString string_PIC32MZ_Evaluation_Board;
leTableString string_INT070_inchi7_0_800x480pixel;
leTableString string_Touch_LCD_INT070;
leTableString string_by_Legato;
leTableString string_NEXT;
leTableString string_Welcome_to;
leTableString string_Harmony_Ver3;
leTableString string_BACK;

void initializeStrings(void)
{
    leTableString_Constructor(&string_LED_Touch_Control, stringID_LED_Touch_Control);
    leTableString_Constructor(&string_TouchAnywhere, stringID_TouchAnywhere);
    leTableString_Constructor(&string_On_Off, stringID_On_Off);
    leTableString_Constructor(&string_PIC32MZ_Evaluation_Board, stringID_PIC32MZ_Evaluation_Board);
    leTableString_Constructor(&string_INT070_inchi7_0_800x480pixel, stringID_INT070_inchi7_0_800x480pixel);
    leTableString_Constructor(&string_Touch_LCD_INT070, stringID_Touch_LCD_INT070);
    leTableString_Constructor(&string_by_Legato, stringID_by_Legato);
    leTableString_Constructor(&string_NEXT, stringID_NEXT);
    leTableString_Constructor(&string_Welcome_to, stringID_Welcome_to);
    leTableString_Constructor(&string_Harmony_Ver3, stringID_Harmony_Ver3);
    leTableString_Constructor(&string_BACK, stringID_BACK);
}
